/**************************************************************************************
 Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: CclIeFb_ErrorCodes.h 77462 2018-08-27 09:01:04Z Sven $:


Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 yyyy-mm-dd    created
**************************************************************************************/

#ifndef CCLIEFB_ERRORCODES_H_INCLUDED
#define CCLIEFB_ERRORCODES_H_INCLUDED


/*
       HIL_COMPONENT_ID_CCLIEFB_IF             =  255:HIL_COMPONENT_ID_CCLIEFB_IF
       HIL_COMPONENT_ID_CCLIEFB_AP             =  256:HIL_COMPONENT_ID_CCLIEFB_AP
       HIL_COMPONENT_ID_SLMP                  =  257:HIL_COMPONENT_ID_SLMP
       HIL_COMPONENT_ID_CCLIEFB_ENDCODE        =  258:HIL_COMPONENT_ID_CCLIEFB_ENDCODE
 */

#ifndef CCLIEFB_ERROR_TABLE_BEGIN
#define CCLIEFB_ERROR_TABLE_BEGIN typedef enum CCLIEFB_ERROR_CODE_Etag {
#endif

#ifndef CCLIEFB_ERROR_RESULT
#define CCLIEFB_ERROR_RESULT(x, v) x = v,
#endif

#ifndef CCLIEFB_ERROR_TABLE_END
#define CCLIEFB_ERROR_TABLE_END CCLIEFB_ERROR_CODE_VALUE_RANGE = 0xFFFFFFFF } CCLIEFB_ERROR_CODE_E;
#endif

CCLIEFB_ERROR_TABLE_BEGIN
#ifndef CCLIEFB_ERROR_TABLE_EXCLUDE_COMMON_ERRORS
CCLIEFB_ERROR_RESULT(CCLIEFB_SUCCESS, 0)

CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_FAIL, 0xC0000001)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_UNEXPECTED, 0xC0000002)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_OUT_OF_MEMORY, 0xC0000003)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_UNKNOWN_COMMAND, 0xC0000004)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INVALID_PARAMETER, 0xC0000009)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_WATCHDOG_TIMEOUT, 0xC000000C)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INVALID_SEQUENCE, 0xC000000F)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_REQUEST_RUNNING, 0xC000001A)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NOT_CONFIGURED, 0xC0000119)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_CONFIGURATION_FAULT, 0xC0000120)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INSUFFICIENT_LICENSE, 0xC0000123)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_PARAMETER_ERROR, 0xC0000124)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NO_MAC_ADDRESS_AVAILABLE, 0xC0000127)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NETWORK_FAULT, 0xC0000140)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_CONNECTION_TIMEOUT, 0xC0000142)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_CABLE_DISCONNECT, 0xC0000145)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_BUS_OFF, 0xC0000180)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_CONFIG_IS_LOCKED, 0xC0000181)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_APPLICATION_ALREADY_REGISTERED, 0xC0000201)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NO_APPLICATION_REGISTERED, 0xC0000202)
#endif

/* HIL_COMPONENT_ID_CCLIEFB                =  0xFE:HIL_COMPONENT_ID_CCLIEFB */
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_REQUEST_DESTINATION_PROBLEM, 0xC0FE0001)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_CONFIGURATION_BUSY, 0xC0FE0002)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_BUS_IS_ON, 0xC0FE0003)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NOT_SUPPORTED, 0xC0FE0004)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_LWIP_INIT, 0xC0FE0005)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INVALID_IP_CONFIG, 0xC0FE0006)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INVALID_NUM_OCCUPIED_STATIONS, 0xC0FE0007)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_INVALID_NUM_STATIONS, 0xC0FE0008)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_NUM_OCCUPIED_STATIONS_EXCEEDED, 0xC0FE0009)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_DUPLICATE_STATION, 0xC0FE000A)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_CMD_SUBCMD_ALREADY_REGISTERED, 0xC0FE000B)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_INVALID_REG_HANDLE, 0xC0FE000C)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_BUS_SCAN_ALREADY_ACTIVE, 0xC0FE000D)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_BUS_SCAN_NOT_ACTIVE, 0xC0FE000E)

/* HIL_COMPONENT_ID_CCLIEFB_IF             =  255:HIL_COMPONENT_ID_CCLIEFB_IF */
/* HIL_COMPONENT_ID_CCLIEFB_AP             =  256:HIL_COMPONENT_ID_CCLIEFB_AP */
/* HIL_COMPONENT_ID_SLMP                  =  257:HIL_COMPONENT_ID_SLMP */
/* HIL_COMPONENT_ID_CCLIEFB_ENDCODE        =  258:HIL_COMPONENT_ID_CCLIEFB_ENDCODE */

/* HIL_COMPONENT_ID_SLMP_ENDCODE          =  0xF6:HIL_COMPONENT_ID_SLMP_ENDCODE */
#ifndef CCLIEFB_EXCLUDE_MAPPING_AREA_DEFINES
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_MAPPING_START, 0xC0F60000)
#endif
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_CMD_SUBCMD_ERROR, 0xC0F6C059)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_ERROR_IN_REQ_MESSAGE, 0xC0F6C05C)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_REQ_LENGTH_DOES_NOT_MATCH, 0xC0F6C061)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_BUSY, 0xC0F6CEE0)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_REQUEST_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE1)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_RESPONSE_SIZE_EXCEEDED_EFFECTIVE_PROCESSING_RANGE, 0xC0F6CEE2)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_SPECIFIED_SERVER_INFO_NUMBER_DOES_NOT_EXIST, 0xC0F6CF10)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_CONTAINED_ITEMS_CANNOT_BE_SET, 0xC0F6CF20)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_PARAMETER_ID_DOES_NOT_EXIST, 0xC0F6CF30)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_WRITE_EXCLUSIVE_START_NOT_PERFORMED, 0xC0F6CF31)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_RELAY_PATH_DESTINATION_COMM_ERROR, 0xC0F6CF70)
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_TIMEOUT_OCCURED, 0xC0F6CF71)
#ifndef CCLIEFB_EXCLUDE_MAPPING_AREA_DEFINES
CCLIEFB_ERROR_RESULT(CCLIEFB_ERROR_SLMP_ENDCODE_MAPPING_END, 0xC0F6FFFF)
#endif

CCLIEFB_ERROR_TABLE_END

#endif
